# 🚀 راهنمای اجرای ربات در هاست اشتراکی سیپنل

## 📋 مقدمه

این راهنما نحوه اجرای ربات خبری پیشرفته تلگرام در هاست اشتراکی سیپنل را توضیح می‌دهد. این ربات دارای دو نسخه PHP و Python است که هر دو قابل اجرا در هاست اشتراکی هستند.

## 🔧 پیش‌نیازها

### برای نسخه PHP:
- **PHP 8.0+** (معمولاً در هاست‌های جدید موجود است)
- **SQLite** (معمولاً فعال است)
- **cURL** (معمولاً فعال است)
- **mbstring** (معمولاً فعال است)
- **Composer** (اختیاری - می‌توانید vendor را آپلود کنید)

### برای نسخه Python:
- **Python 3.8+** (در برخی هاست‌ها موجود است)
- **pip** (برای نصب پکیج‌ها)

## 📁 مراحل نصب

### مرحله 1: آپلود فایل‌ها

1. **آپلود پروژه** به پوشه `public_html` یا `www` هاست خود
2. **تنظیم مجوزها**:
   ```bash
   chmod 755 storage/
   chmod 644 storage/database.sqlite
   chmod 755 scripts/
   ```

### مرحله 2: تنظیمات اولیه

#### برای نسخه PHP:
1. **کپی فایل تنظیمات**:
   ```bash
   cp env.example .env
   ```

2. **ویرایش فایل `.env`**:
   ```env
   # توکن ربات تلگرام
   BOT_TOKEN=YOUR_BOT_TOKEN_HERE
   
   # شناسه کانال تلگرام
   CHANNEL_ID=YOUR_CHANNEL_ID_HERE
   
   # کلید API اخبار
   NEWS_API_KEY=YOUR_NEWS_API_KEY_HERE
   
   # سایر تنظیمات...
   ```

#### برای نسخه Python:
1. **ویرایش فایل `py/advanced_news_bot.py`**:
   ```python
   class Config:
       BOT_TOKEN = "YOUR_BOT_TOKEN_HERE"
       CHANNEL_ID = "YOUR_CHANNEL_ID_HERE"
       NEWS_API_KEY = "YOUR_NEWS_API_KEY_HERE"
   ```

### مرحله 3: نصب وابستگی‌ها

#### برای نسخه PHP:
```bash
# اگر Composer موجود است
composer install

# یا آپلود پوشه vendor از سیستم محلی
```

#### برای نسخه Python:
```bash
pip install -r requirements.txt
```

## ⏰ تنظیم Cron Job

### آیا نیاز به Cron Job دارید؟

**بله!** این ربات برای اجرای خودکار نیاز به Cron Job دارد.

### نحوه تنظیم Cron Job در سیپنل:

1. **ورود به سیپنل** هاست خود
2. **رفتن به بخش Cron Jobs**
3. **اضافه کردن Cron Job جدید**:

#### برای نسخه PHP:
```bash
# هر 30 دقیقه یکبار اجرا شود
*/30 * * * * /usr/bin/php /home/username/public_html/index.php

# یا اگر مسیر PHP متفاوت است:
*/30 * * * * /usr/local/bin/php /home/username/public_html/index.php
```

#### برای نسخه Python:
```bash
# هر 30 دقیقه یکبار اجرا شود
*/30 * * * * /usr/bin/python3 /home/username/public_html/py/advanced_news_bot.py
```

### تنظیمات پیشنهادی Cron Job:

```bash
# بررسی اخبار هر 30 دقیقه
*/30 * * * * /usr/bin/php /home/username/public_html/index.php

# پشتیبان‌گیری روزانه در ساعت 2 شب
0 2 * * * /usr/bin/php /home/username/public_html/scripts/backup.php

# پاک‌سازی هفتگی در ساعت 3 شب یکشنبه
0 3 * * 0 /usr/bin/php /home/username/public_html/scripts/cleanup.php
```

## 🔗 تنظیم Webhook

### آیا نیاز به Webhook دارید؟

**خیر!** این ربات از روش **Polling** استفاده می‌کند، نه Webhook. یعنی:
- ربات خودش به تلگرام وصل می‌شود
- نیازی به دریافت درخواست از تلگرام نیست
- برای هاست اشتراکی مناسب‌تر است

### مزایای روش Polling:
- ✅ نیازی به SSL نیست
- ✅ نیازی به دامنه عمومی نیست
- ✅ کار با هاست اشتراکی آسان‌تر است
- ✅ نیازی به تنظیم Webhook نیست

## 🚀 اجرای ربات

### روش 1: اجرای دستی (تست)
```bash
# برای نسخه PHP
php index.php

# برای نسخه Python
python3 py/advanced_news_bot.py
```

### روش 2: اجرای خودکار (تولید)
ربات از طریق Cron Job به صورت خودکار اجرا می‌شود.

## 🔧 تنظیمات پیشرفته

### محدودیت‌های هاست اشتراکی:

1. **محدودیت زمان اجرا**: معمولاً 30-60 ثانیه
2. **محدودیت حافظه**: معمولاً 128-256 MB
3. **محدودیت CPU**: معمولاً کم

### راه‌حل‌ها:

1. **کاهش فاصله بررسی اخبار**:
   ```env
   NEWS_CHECK_INTERVAL=60  # هر ساعت به جای هر 30 دقیقه
   ```

2. **کاهش تعداد منابع خبری**:
   ```php
   // در config/app.php
   'news_sources' => [
       'english' => ['bbc-news', 'cnn'], // فقط 2 منبع
   ]
   ```

3. **فعال‌سازی کش**:
   ```env
   CACHE_ENABLED=true
   CACHE_TTL=3600
   ```

## 📊 مانیتورینگ

### بررسی وضعیت ربات:

1. **از طریق دستورات تلگرام**:
   - `/status` - وضعیت ربات
   - `/stats` - آمار کامل

2. **از طریق فایل‌های لاگ**:
   ```bash
   tail -f storage/logs/bot_manager.log
   ```

3. **از طریق Cron Job**:
   - بررسی لاگ‌های Cron در سیپنل
   - ارسال ایمیل در صورت خطا

## 🛠️ عیب‌یابی

### مشکلات رایج:

#### 1. خطای "Permission Denied"
```bash
chmod 755 storage/
chmod 644 storage/database.sqlite
```

#### 2. خطای "Class not found"
```bash
# برای PHP
composer install
composer dump-autoload
```

#### 3. خطای اتصال به تلگرام
- بررسی توکن ربات
- بررسی شناسه کانال
- بررسی اتصال اینترنت هاست

#### 4. خطای API اخبار
- بررسی کلید API
- بررسی محدودیت‌های API
- کاهش تعداد درخواست‌ها

### بررسی لاگ‌ها:
```bash
# لاگ اصلی ربات
tail -f storage/logs/bot_manager.log

# لاگ تلگرام
tail -f storage/logs/telegram_bot.log

# لاگ دریافت اخبار
tail -f storage/logs/news_fetcher.log
```

## 🔒 امنیت

### نکات امنیتی:

1. **مخفی کردن فایل `.env`**:
   ```bash
   chmod 600 .env
   ```

2. **محدود کردن دسترسی**:
   ```bash
   chmod 755 scripts/
   chmod 644 storage/database.sqlite
   ```

3. **استفاده از HTTPS** (اختیاری):
   - برای اتصال امن‌تر به API ها

## 📈 بهینه‌سازی عملکرد

### برای هاست اشتراکی:

1. **کاهش مصرف منابع**:
   ```env
   MAX_POSTS_PER_HOUR=5
   MAX_POSTS_PER_DAY=20
   NEWS_CHECK_INTERVAL=60
   ```

2. **فعال‌سازی کش**:
   ```env
   CACHE_ENABLED=true
   CACHE_TTL=7200
   ```

3. **پاک‌سازی خودکار**:
   ```env
   CLEANUP_INTERVAL=12
   ```

## 🆘 پشتیبانی

### در صورت مشکل:

1. **بررسی لاگ‌ها**
2. **تست دستی ربات**
3. **بررسی تنظیمات Cron Job**
4. **تماس با پشتیبانی هاست**

### دستورات مفید:

```bash
# تست اتصال به تلگرام
php index.php --test

# اجرای دستی بررسی اخبار
php index.php --manual

# نمایش وضعیت
php index.php --status
```

## 📝 خلاصه

### مراحل کلیدی:
1. ✅ آپلود فایل‌ها
2. ✅ تنظیم فایل `.env`
3. ✅ تنظیم Cron Job
4. ❌ **نیازی به Webhook نیست**
5. ✅ تست و مانیتورینگ

### مزایای این روش:
- 🚀 اجرای آسان در هاست اشتراکی
- 🔒 امنیت بالا
- 📊 مانیتورینگ کامل
- ⚡ عملکرد بهینه
- 🛠️ عیب‌یابی آسان

---

**نکته مهم**: این ربات برای اجرای مداوم طراحی شده و نیاز به Cron Job دارد. بدون Cron Job، ربات فقط یکبار اجرا می‌شود و متوقف می‌شود.
