<?php

/**
 * اسکریپت پشتیبان‌گیری از پایگاه داده
 * Database Backup Script
 */

require_once __DIR__ . '/../vendor/autoload.php';
require_once __DIR__ . '/../src/Config.php';
require_once __DIR__ . '/../src/DatabaseManager.php';

echo "💾 پشتیبان‌گیری از پایگاه داده\n";
echo "=" . str_repeat("=", 40) . "\n";

try {
    $dbPath = Config::get('database.path', __DIR__ . '/../storage/database.sqlite');
    $db = new DatabaseManager($dbPath);
    
    // ایجاد پوشه پشتیبان اگر وجود ندارد
    $backupDir = __DIR__ . '/../storage/backups';
    if (!is_dir($backupDir)) {
        mkdir($backupDir, 0755, true);
    }
    
    // نام فایل پشتیبان
    $backupFile = $backupDir . '/backup_' . date('Y-m-d_H-i-s') . '.sqlite';
    
    // پشتیبان‌گیری
    if ($db->backup($backupFile)) {
        echo "✅ پشتیبان‌گیری با موفقیت انجام شد\n";
        echo "📁 فایل: $backupFile\n";
        
        // نمایش اندازه فایل
        $fileSize = filesize($backupFile);
        echo "📊 اندازه: " . number_format($fileSize / 1024, 2) . " KB\n";
        
        // پاک‌سازی پشتیبان‌های قدیمی
        $retentionDays = Config::get('backup.retention_days', 30);
        $cutoffDate = strtotime("-$retentionDays days");
        
        $files = glob($backupDir . '/backup_*.sqlite');
        $deletedCount = 0;
        
        foreach ($files as $file) {
            if (filemtime($file) < $cutoffDate) {
                unlink($file);
                $deletedCount++;
            }
        }
        
        if ($deletedCount > 0) {
            echo "🗑️ $deletedCount فایل پشتیبان قدیمی حذف شد\n";
        }
        
    } else {
        echo "❌ خطا در پشتیبان‌گیری\n";
        exit(1);
    }
    
} catch (Exception $e) {
    echo "❌ خطا: " . $e->getMessage() . "\n";
    exit(1);
}
