<?php

/**
 * اسکریپت بررسی وضعیت ربات
 * Bot Status Check Script
 */

// بارگذاری autoloader
require_once __DIR__ . '/../vendor/autoload.php';
require_once __DIR__ . '/../src/Config.php';
require_once __DIR__ . '/../src/DatabaseManager.php';
require_once __DIR__ . '/../src/Services/TranslationService.php';
require_once __DIR__ . '/../src/Services/NewsFetcher.php';
require_once __DIR__ . '/../src/Services/TelegramBot.php';

echo "📊 بررسی وضعیت ربات...\n";
echo "=" . str_repeat("=", 50) . "\n";

try {
    // اتصال به پایگاه داده
    $dbPath = Config::get('database.path', __DIR__ . '/../storage/database.sqlite');
    $db = new DatabaseManager($dbPath);
    
    // ایجاد ربات
    $botToken = Config::get('bot.token');
    $channelId = Config::get('bot.channel_id');
    
    $bot = new TelegramBot($botToken, $channelId, $db);
    
    // بررسی اتصال به تلگرام
    echo "📡 بررسی اتصال به تلگرام...\n";
    $botInfo = $bot->getBotInfo();
    
    if (!empty($botInfo)) {
        echo "✅ اتصال به تلگرام موفق\n";
        echo "   نام ربات: " . $botInfo['first_name'] . "\n";
        echo "   نام کاربری: @" . ($botInfo['username'] ?? 'ندارد') . "\n";
    } else {
        echo "❌ خطا در اتصال به تلگرام\n";
    }
    
    // بررسی پیام‌های جدید
    echo "\n📨 بررسی پیام‌های جدید...\n";
    $updates = $bot->getUpdates();
    echo "✅ " . count($updates) . " پیام جدید دریافت شد\n";
    
    if (!empty($updates)) {
        echo "\n📋 آخرین پیام‌ها:\n";
        foreach (array_slice($updates, -5) as $update) {
            if (isset($update['message'])) {
                $msg = $update['message'];
                $text = $msg['text'] ?? 'بدون متن';
                $from = $msg['from']['username'] ?? $msg['from']['first_name'] ?? 'نامشخص';
                $date = date('H:i:s', $msg['date']);
                echo "   - {$date} از {$from}: {$text}\n";
            }
        }
    }
    
    // بررسی آمار
    echo "\n📊 آمار ربات:\n";
    $canPost = $bot->canPostNow();
    echo "✅ امکان ارسال پست: " . ($canPost ? "بله" : "خیر") . "\n";
    
    // بررسی جداول پایگاه داده
    echo "\n🗄️ بررسی پایگاه داده...\n";
    $tables = $db->query("SELECT name FROM sqlite_master WHERE type='table'")->fetchAll(PDO::FETCH_COLUMN);
    echo "✅ " . count($tables) . " جدول موجود است\n";
    
    // بررسی کاربران ادمین
    $adminCount = $db->query("SELECT COUNT(*) FROM admin_users WHERE is_active = 1")->fetchColumn();
    echo "✅ " . $adminCount . " کاربر ادمین فعال\n";
    
    // بررسی مقالات
    $articleCount = $db->query("SELECT COUNT(*) FROM articles")->fetchColumn();
    echo "✅ " . $articleCount . " مقاله در پایگاه داده\n";
    
    echo "\n🎉 بررسی وضعیت تکمیل شد!\n";
    
    if (count($updates) > 0) {
        echo "\n💡 نکته: ربات پیام‌ها را دریافت می‌کند.\n";
        echo "   اگر به دستورات پاسخ نمی‌دهد، احتمالاً:\n";
        echo "   1. ربات در حال اجرا نیست\n";
        echo "   2. حلقه پردازش پیام‌ها کار نمی‌کند\n";
        echo "   3. مشکل در تابع handlePrivateMessage\n";
    }
    
} catch (Exception $e) {
    echo "❌ خطا در بررسی وضعیت: " . $e->getMessage() . "\n";
    exit(1);
}
