<?php

/**
 * اسکریپت ساده اجرای ربات
 * Simple Bot Runner
 */

// بارگذاری autoloader
require_once __DIR__ . '/../vendor/autoload.php';
require_once __DIR__ . '/../src/Config.php';
require_once __DIR__ . '/../src/DatabaseManager.php';
require_once __DIR__ . '/../src/Services/TranslationService.php';
require_once __DIR__ . '/../src/Services/NewsFetcher.php';
require_once __DIR__ . '/../src/Services/TelegramBot.php';

echo "🤖 شروع ربات ساده...\n";
echo "=" . str_repeat("=", 30) . "\n";

try {
    // اتصال به پایگاه داده
    $dbPath = Config::get('database.path', __DIR__ . '/../storage/database.sqlite');
    $db = new DatabaseManager($dbPath);
    
    // ایجاد ربات
    $botToken = Config::get('bot.token');
    $channelId = Config::get('bot.channel_id');
    
    $bot = new TelegramBot($botToken, $channelId, $db);
    
    echo "✅ ربات آماده است\n";
    echo "📱 در حال پردازش پیام‌ها...\n";
    echo "⏹️ برای توقف Ctrl+C را فشار دهید\n\n";
    
    while (true) {
        try {
            // دریافت پیام‌های جدید
            $updates = $bot->getUpdates();
            
            if (!empty($updates)) {
                echo "📨 " . count($updates) . " پیام جدید دریافت شد\n";
                
                foreach ($updates as $update) {
                    if (isset($update['message']) && $update['message']['chat']['type'] === 'private') {
                        $message = $update['message'];
                        $chatId = $message['chat']['id'];
                        $text = $message['text'] ?? '';
                        $from = $message['from']['username'] ?? $message['from']['first_name'] ?? 'نامشخص';
                        
                        echo "   📝 از {$from}: {$text}\n";
                        
                        // پردازش پیام
                        $bot->handlePrivateMessage($message);
                        
                        echo "   ✅ پاسخ ارسال شد\n";
                    }
                }
                echo "\n";
            }
            
            // انتظار کوتاه
            sleep(3);
            
        } catch (Exception $e) {
            echo "❌ خطا: " . $e->getMessage() . "\n";
            sleep(5);
        }
    }
    
} catch (Exception $e) {
    echo "❌ خطا در شروع ربات: " . $e->getMessage() . "\n";
    exit(1);
}
