<?php

/**
 * اسکریپت شبیه‌سازی پیام به ربات
 * Simulate Message to Bot
 */

// بارگذاری autoloader
require_once __DIR__ . '/../vendor/autoload.php';
require_once __DIR__ . '/../src/Config.php';
require_once __DIR__ . '/../src/DatabaseManager.php';
require_once __DIR__ . '/../src/Services/TranslationService.php';
require_once __DIR__ . '/../src/Services/NewsFetcher.php';
require_once __DIR__ . '/../src/Services/TelegramBot.php';

echo "🎭 شبیه‌سازی پیام به ربات...\n";

try {
    // اتصال به پایگاه داده
    $dbPath = Config::get('database.path', __DIR__ . '/../storage/database.sqlite');
    $db = new DatabaseManager($dbPath);
    
    // ایجاد ربات
    $botToken = Config::get('bot.token');
    $channelId = Config::get('bot.channel_id');
    
    $bot = new TelegramBot($botToken, $channelId, $db);
    
    // شبیه‌سازی پیام /start
    $testMessage = [
        'message_id' => rand(1000, 9999),
        'from' => [
            'id' => 315447992,
            'username' => 'Hemn4827',
            'first_name' => 'Hemn'
        ],
        'chat' => [
            'id' => 315447992,
            'type' => 'private'
        ],
        'text' => '/start',
        'date' => time()
    ];
    
    echo "📤 شبیه‌سازی پیام: /start\n";
    
    // پردازش پیام
    $bot->handlePrivateMessage($testMessage);
    
    echo "✅ پیام پردازش شد\n";
    
    // انتظار کوتاه
    sleep(2);
    
    // شبیه‌سازی پیام /help
    $testMessage['text'] = '/help';
    $testMessage['message_id'] = rand(1000, 9999);
    
    echo "📤 شبیه‌سازی پیام: /help\n";
    
    // پردازش پیام
    $bot->handlePrivateMessage($testMessage);
    
    echo "✅ پیام پردازش شد\n";
    
    echo "\n🎉 شبیه‌سازی تکمیل شد!\n";
    echo "اگر ربات در حال اجرا است، باید پاسخ‌ها را دریافت کرده باشید.\n";
    
} catch (Exception $e) {
    echo "❌ خطا: " . $e->getMessage() . "\n";
}
