<?php

/**
 * اسکریپت تست عملکرد ربات
 * Bot Functionality Test Script
 */

// بارگذاری autoloader
require_once __DIR__ . '/../vendor/autoload.php';
require_once __DIR__ . '/../src/Config.php';
require_once __DIR__ . '/../src/DatabaseManager.php';
require_once __DIR__ . '/../src/Services/TranslationService.php';
require_once __DIR__ . '/../src/Services/NewsFetcher.php';
require_once __DIR__ . '/../src/Services/TelegramBot.php';

echo "🧪 تست عملکرد ربات تلگرام...\n";
echo "=" . str_repeat("=", 50) . "\n";

try {
    // اتصال به پایگاه داده
    $dbPath = Config::get('database.path', __DIR__ . '/../storage/database.sqlite');
    $db = new DatabaseManager($dbPath);
    
    echo "✅ اتصال به پایگاه داده موفق\n";
    
    // ایجاد ربات
    $botToken = Config::get('bot.token');
    $channelId = Config::get('bot.channel_id');
    
    if (empty($botToken) || empty($channelId)) {
        throw new Exception('توکن ربات یا شناسه کانال تنظیم نشده است');
    }
    
    $bot = new TelegramBot($botToken, $channelId, $db);
    echo "✅ ربات تلگرام ایجاد شد\n";
    
    // تست دریافت اطلاعات ربات
    echo "\n📡 تست اتصال به تلگرام...\n";
    $botInfo = $bot->getBotInfo();
    
    if (!empty($botInfo)) {
        echo "✅ اتصال به تلگرام موفق\n";
        echo "   نام ربات: " . $botInfo['first_name'] . "\n";
        echo "   نام کاربری: @" . ($botInfo['username'] ?? 'ندارد') . "\n";
    } else {
        echo "❌ خطا در اتصال به تلگرام\n";
    }
    
    // تست ارسال پیام تست
    echo "\n📤 تست ارسال پیام...\n";
    $testMessage = "🧪 تست اتصال ربات - " . date('Y/m/d H:i:s');
    $success = $bot->sendMessage($testMessage);
    
    if ($success) {
        echo "✅ پیام تست با موفقیت ارسال شد\n";
    } else {
        echo "❌ خطا در ارسال پیام تست\n";
    }
    
    // تست دریافت پیام‌ها
    echo "\n📨 تست دریافت پیام‌ها...\n";
    $updates = $bot->getUpdates();
    echo "✅ " . count($updates) . " پیام جدید دریافت شد\n";
    
    // تست ارسال پیام خصوصی
    echo "\n💬 تست ارسال پیام خصوصی...\n";
    $adminUserId = 315447992; // شناسه کاربر ادمین
    $privateMessage = "🤖 سلام! ربات آماده استفاده است.\n\n";
    $privateMessage .= "📋 دستورات موجود:\n";
    $privateMessage .= "/start - شروع ربات\n";
    $privateMessage .= "/help - راهنما\n";
    $privateMessage .= "/status - وضعیت ربات\n";
    $privateMessage .= "/news - آخرین اخبار\n";
    
    $privateSuccess = $bot->sendPrivateMessage($adminUserId, $privateMessage);
    
    if ($privateSuccess) {
        echo "✅ پیام خصوصی با موفقیت ارسال شد\n";
    } else {
        echo "❌ خطا در ارسال پیام خصوصی\n";
    }
    
    // بررسی آمار
    echo "\n📊 بررسی آمار ربات...\n";
    $canPost = $bot->canPostNow();
    echo "✅ امکان ارسال پست: " . ($canPost ? "بله" : "خیر") . "\n";
    
    echo "\n🎉 تست‌ها تکمیل شد!\n";
    echo "ربات آماده استفاده است.\n";
    
} catch (Exception $e) {
    echo "❌ خطا در تست: " . $e->getMessage() . "\n";
    exit(1);
}
