# 🤖 ربات خبری پیشرفته تلگرام - نسخه PHP

ربات پیشرفته و حرفه‌ای مدیریت کانال اخبار تلگرام که اخبار مربوط به فارکس، کریپتو و اقتصاد را از منابع مختلف جمع‌آوری کرده و در کانال تلگرام منتشر می‌کند.

## ✨ ویژگی‌های کلیدی

### 🚀 امکانات پیشرفته
- **معماری MVC حرفه‌ای** - کد منظم و قابل نگهداری
- **سیستم Migration** - مدیریت آسان تغییرات پایگاه داده
- **کش پیشرفته** - بهبود عملکرد با کش حافظه و پایگاه داده
- **سیستم لاگ‌گیری کامل** - ردیابی تمام فعالیت‌ها و خطاها
- **پشتیبان‌گیری خودکار** - محافظت از داده‌ها
- **مانیتورینگ پیشرفته** - نظارت بر سلامت سیستم

### 📰 دریافت اخبار چندمنظوره
- **NewsAPI** - اخبار از منابع معتبر جهانی
- **RSS Feeds** - اخبار از منابع انگلیسی و فارسی
- **منابع کریپتو** - CoinTelegraph، CoinDesk، Bitcoin Magazine
- **منابع فارکس** - Forex Factory، DailyFX، FXStreet
- **منابع ایرانی** - تسنیم، مهر، ایسنا، فارس، ایرنا

### 🌐 ترجمه هوشمند
- **چندین سرویس ترجمه** - MyMemory، LibreTranslate، Google Translate
- **کش پیشرفته** - ذخیره ترجمه‌ها برای بهبود عملکرد
- **کیفیت‌سنجی** - بررسی کیفیت ترجمه‌ها
- **ترجمه متن‌های طولانی** - تقسیم به جملات کوچک

### 🎯 فیلتر هوشمند
- **دسته‌بندی خودکار** - کریپتو، فارکس، اقتصاد، ایران، سیاست، فناوری
- **کلمات کلیدی پیشرفته** - شناسایی اخبار مهم
- **جلوگیری از تکرار** - سیستم هش برای شناسایی اخبار تکراری
- **اولویت‌بندی** - ارسال اخبار مهم‌تر اول

### ⚙️ مدیریت پیشرفته
- **دستورات تلگرام** - کنترل ربات از طریق پیام خصوصی
- **محدودیت‌های قابل تنظیم** - کنترل تعداد پست‌ها
- **سیستم ادمین** - دسترسی محدود به کاربران مجاز
- **آمارگیری کامل** - گزارش‌های تفصیلی عملکرد

## 🛠️ نصب و راه‌اندازی

### پیش‌نیازها
- **PHP 8.0+** - نسخه جدید PHP
- **Composer** - مدیریت وابستگی‌ها
- **SQLite** - پایگاه داده سبک
- **cURL** - درخواست‌های HTTP
- **mbstring** - پشتیبانی از کاراکترهای چندبایتی

### مراحل نصب

#### 1. کلون کردن پروژه
```bash
git clone <repository-url>
cd advanced_news_bot
```

#### 2. نصب وابستگی‌ها
```bash
composer install
```

#### 3. راه‌اندازی اولیه
```bash
php scripts/install.php
```

#### 4. تنظیم متغیرهای محیطی
فایل `.env` را ویرایش کنید:
```env
# توکن ربات تلگرام
BOT_TOKEN=your_bot_token_here

# شناسه کانال تلگرام
CHANNEL_ID=your_channel_id_here

# کلید API اخبار
NEWS_API_KEY=your_news_api_key_here

# سایر تنظیمات...
```

#### 5. اجرای ربات
```bash
# اجرای عادی
php index.php

# اجرای تست
php index.php --test

# اجرای دستی
php index.php --manual

# نمایش وضعیت
php index.php --status
```

### تنظیم Cron Job

برای اجرای خودکار ربات:
```bash
# هر 30 دقیقه یکبار اجرا شود
*/30 * * * * /usr/bin/php /path/to/your/project/index.php

# پشتیبان‌گیری روزانه
0 2 * * * /usr/bin/php /path/to/your/project/scripts/backup.php

# پاک‌سازی هفتگی
0 3 * * 0 /usr/bin/php /path/to/your/project/scripts/cleanup.php
```

## 📁 ساختار پروژه

```
advanced_news_bot/
├── 📁 config/                 # تنظیمات برنامه
│   └── app.php               # تنظیمات اصلی
├── 📁 src/                    # کد منبع
│   ├── Config.php            # مدیریت تنظیمات
│   ├── DatabaseManager.php   # مدیریت پایگاه داده
│   ├── 📁 Models/            # مدل‌های پایگاه داده
│   │   ├── BaseModel.php     # مدل پایه
│   │   └── Article.php       # مدل مقالات
│   └── 📁 Services/          # سرویس‌ها
│       ├── NewsFetcher.php   # دریافت اخبار
│       ├── TranslationService.php # ترجمه
│       └── TelegramBot.php   # ربات تلگرام
├── 📁 database/              # پایگاه داده
│   └── 📁 migrations/        # فایل‌های migration
├── 📁 storage/               # ذخیره‌سازی
│   ├── 📁 logs/              # فایل‌های لاگ
│   ├── 📁 cache/             # کش
│   └── 📁 backups/           # پشتیبان‌ها
├── 📁 scripts/               # اسکریپت‌های کمکی
│   ├── install.php           # نصب
│   ├── backup.php            # پشتیبان‌گیری
│   └── cleanup.php           # پاک‌سازی
├── index.php                 # فایل اصلی
├── composer.json             # وابستگی‌ها
└── env.example               # نمونه تنظیمات
```

## 🎮 دستورات ربات

### دستورات تلگرام
- `/start` - شروع ربات
- `/help` - راهنما
- `/status` - وضعیت ربات
- `/stats` - آمار کامل
- `/news` - آخرین اخبار
- `/test` - تست اتصال
- `/fetch` - دریافت اخبار جدید
- `/settings` - تنظیمات

### دستورات خط فرمان
```bash
# اجرای عادی
php index.php

# تست عملکرد
php index.php --test

# اجرای دستی
php index.php --manual

# نمایش وضعیت
php index.php --status

# پشتیبان‌گیری
php scripts/backup.php

# پاک‌سازی
php scripts/cleanup.php [روزهای_قدیمی]
```

## ⚙️ تنظیمات پیشرفته

### محدودیت‌های ارسال
```env
MAX_POSTS_PER_HOUR=10      # حداکثر پست در ساعت
MAX_POSTS_PER_DAY=50       # حداکثر پست در روز
MIN_NEWS_INTERVAL=5        # حداقل فاصله بین پست‌ها (دقیقه)
```

### منابع خبری
```php
// در config/app.php
'news_sources' => [
    'english' => ['bbc-news', 'cnn', 'the-guardian', ...],
    'persian' => ['https://www.tasnimnews.com/fa/rss/...', ...],
    'crypto' => ['https://cointelegraph.com/rss', ...],
    'forex' => ['https://www.forexfactory.com/rss.php', ...]
]
```

### کلمات کلیدی
```php
'keywords' => [
    'crypto' => ['bitcoin', 'crypto', 'cryptocurrency', ...],
    'forex' => ['forex', 'trading', 'fx', 'currency', ...],
    'economy' => ['economy', 'inflation', 'fed', ...],
    'iran' => ['iran', 'iranian', 'persian', ...]
]
```

## 📊 آمار و مانیتورینگ

### آمار ربات
- تعداد کل پست‌ها
- پست‌های امروز، این ساعت، این هفته، این ماه
- تعداد خطاها
- آخرین فعالیت

### آمار ترجمه
- نرخ موفقیت کش
- تعداد ترجمه‌ها
- آمار بر اساس سرویس

### آمار منابع خبری
- تعداد دریافت از هر منبع
- آخرین دریافت
- تعداد خطاها

## 🔧 عیب‌یابی

### مشکلات رایج

#### 1. خطای "Class not found"
```bash
composer install
composer dump-autoload
```

#### 2. خطای اتصال به تلگرام
- بررسی توکن ربات
- بررسی شناسه کانال
- بررسی اتصال اینترنت

#### 3. خطای API اخبار
- بررسی کلید API
- بررسی محدودیت‌های API
- بررسی اتصال اینترنت

#### 4. خطای پایگاه داده
```bash
# بررسی مجوزها
chmod 755 storage/
chmod 644 storage/database.sqlite

# اجرای migration
php scripts/install.php
```

### فایل‌های لاگ
- `storage/logs/bot_manager.log` - لاگ مدیر ربات
- `storage/logs/telegram_bot.log` - لاگ ربات تلگرام
- `storage/logs/news_fetcher.log` - لاگ دریافت اخبار
- `storage/logs/translation.log` - لاگ ترجمه
- `storage/logs/database.log` - لاگ پایگاه داده

## 🚀 ویژگی‌های پیشرفته

### سیستم کش
- کش حافظه برای ترجمه‌ها
- کش پایگاه داده برای بهبود عملکرد
- کش منابع خبری

### پشتیبان‌گیری خودکار
- پشتیبان‌گیری روزانه از پایگاه داده
- نگهداری پشتیبان‌ها برای مدت مشخص
- پاک‌سازی خودکار پشتیبان‌های قدیمی

### مانیتورینگ سلامت
- بررسی اتصال به سرویس‌ها
- نظارت بر عملکرد سیستم
- هشدار در صورت بروز مشکل

### امنیت
- سیستم احراز هویت ادمین
- محدودیت دسترسی
- لاگ‌گیری فعالیت‌ها

## 🤝 مشارکت

برای مشارکت در پروژه:
1. Fork کنید
2. شاخه جدید ایجاد کنید (`git checkout -b feature/amazing-feature`)
3. تغییرات خود را commit کنید (`git commit -m 'Add amazing feature'`)
4. Push کنید (`git push origin feature/amazing-feature`)
5. Pull Request ارسال کنید

## 📄 مجوز

این پروژه تحت مجوز MIT منتشر شده است. برای جزئیات بیشتر فایل `LICENSE` را مطالعه کنید.

## 🆘 پشتیبانی

برای پشتیبانی و گزارش باگ:
- Issue جدید ایجاد کنید
- ایمیل: support@example.com
- تلگرام: @support_bot

## 📈 نسخه‌ها

### نسخه 2.0.0 (فعلی)
- معماری MVC کامل
- سیستم Migration
- کش پیشرفته
- مانیتورینگ کامل
- پشتیبان‌گیری خودکار

### نسخه 1.0.0 (Python)
- نسخه اولیه با Python
- امکانات پایه

---

**نکته**: این ربات برای استفاده آموزشی و شخصی طراحی شده است. لطفاً قوانین و مقررات مربوط به استفاده از API ها و سرویس‌های خارجی را رعایت کنید.
