<?php

/**
 * اسکریپت اجرای ربات بهبود یافته
 * Improved Bot Runner with Conflict Resolution
 */

// بارگذاری autoloader
require_once __DIR__ . '/../vendor/autoload.php';
require_once __DIR__ . '/../src/Config.php';
require_once __DIR__ . '/../src/DatabaseManager.php';
require_once __DIR__ . '/../src/Services/TranslationService.php';
require_once __DIR__ . '/../src/Services/NewsFetcher.php';
require_once __DIR__ . '/../src/Services/TelegramBot.php';

echo "🤖 شروع ربات بهبود یافته...\n";
echo "=" . str_repeat("=", 40) . "\n";

try {
    // اتصال به پایگاه داده
    $dbPath = Config::get('database.path', __DIR__ . '/../storage/database.sqlite');
    $db = new DatabaseManager($dbPath);
    
    // ایجاد ربات
    $botToken = Config::get('bot.token');
    $channelId = Config::get('bot.channel_id');
    
    $bot = new TelegramBot($botToken, $channelId, $db);
    
    echo "✅ ربات آماده است\n";
    echo "📱 در حال پردازش پیام‌ها...\n";
    echo "⏹️ برای توقف Ctrl+C را فشار دهید\n\n";
    
    $lastUpdateId = 0;
    $errorCount = 0;
    $maxErrors = 5;
    
    while (true) {
        try {
            // دریافت پیام‌های جدید با offset مناسب
            $updates = $bot->getUpdates();
            
            if (!empty($updates)) {
                echo "📨 " . count($updates) . " پیام جدید دریافت شد\n";
                
                foreach ($updates as $update) {
                    if (isset($update['message']) && $update['message']['chat']['type'] === 'private') {
                        $message = $update['message'];
                        $chatId = $message['chat']['id'];
                        $text = $message['text'] ?? '';
                        $from = $message['from']['username'] ?? $message['from']['first_name'] ?? 'نامشخص';
                        
                        echo "   📝 از {$from}: {$text}\n";
                        
                        // پردازش پیام
                        $bot->handlePrivateMessage($message);
                        
                        echo "   ✅ پاسخ ارسال شد\n";
                    }
                    
                    // به‌روزرسانی آخرین update_id
                    $lastUpdateId = $update['update_id'];
                }
                echo "\n";
                
                // Reset error count on successful processing
                $errorCount = 0;
            }
            
            // انتظار کوتاه
            sleep(2);
            
        } catch (Exception $e) {
            $errorCount++;
            echo "❌ خطا ({$errorCount}/{$maxErrors}): " . $e->getMessage() . "\n";
            
            if ($errorCount >= $maxErrors) {
                echo "🛑 تعداد خطاها زیاد شد. ربات متوقف می‌شود.\n";
                break;
            }
            
            // انتظار بیشتر در صورت خطا
            sleep(10);
        }
    }
    
} catch (Exception $e) {
    echo "❌ خطا در شروع ربات: " . $e->getMessage() . "\n";
    exit(1);
}

echo "\n👋 ربات متوقف شد.\n";
