<?php

/**
 * اسکریپت نصب و راه‌اندازی اولیه
 * Installation and Initial Setup Script
 */

require_once __DIR__ . '/../vendor/autoload.php';
require_once __DIR__ . '/../src/Config.php';
require_once __DIR__ . '/../src/DatabaseManager.php';

echo "🚀 راه‌اندازی ربات خبری پیشرفته تلگرام\n";
echo "=" . str_repeat("=", 50) . "\n";

try {
    // بررسی وجود فایل .env
    if (!file_exists(__DIR__ . '/../.env')) {
        echo "📝 ایجاد فایل تنظیمات...\n";
        copy(__DIR__ . '/../env.example', __DIR__ . '/../.env');
        echo "✅ فایل .env ایجاد شد. لطفاً تنظیمات را ویرایش کنید.\n";
    }
    
    // ایجاد پوشه‌های مورد نیاز
    $directories = [
        'storage',
        'storage/logs',
        'storage/cache',
        'storage/backups',
        'database/migrations'
    ];
    
    foreach ($directories as $dir) {
        $path = __DIR__ . '/../' . $dir;
        if (!is_dir($path)) {
            mkdir($path, 0755, true);
            echo "📁 پوشه $dir ایجاد شد\n";
        }
    }
    
    // مقداردهی پایگاه داده
    echo "🗄️ مقداردهی پایگاه داده...\n";
    $dbPath = __DIR__ . '/../storage/database.sqlite';
    $db = new DatabaseManager($dbPath);
    echo "✅ پایگاه داده با موفقیت مقداردهی شد\n";
    
    // بررسی تنظیمات
    echo "⚙️ بررسی تنظیمات...\n";
    $errors = Config::validate();
    if (!empty($errors)) {
        echo "❌ خطاهای تنظیمات:\n";
        foreach ($errors as $error) {
            echo "   - $error\n";
        }
        echo "\nلطفاً فایل .env را ویرایش کنید.\n";
        exit(1);
    }
    echo "✅ تنظیمات صحیح است\n";
    
    // تست اتصالات
    echo "🧪 تست اتصالات...\n";
    
    // تست اتصال به تلگرام
    $botToken = Config::get('bot.token');
    $channelId = Config::get('bot.channel_id');
    
    $client = new GuzzleHttp\Client();
    $response = $client->get("https://api.cwrtex.ir/bot{$botToken}/getMe");
    $result = json_decode($response->getBody(), true);
    
    if ($result['ok']) {
        echo "✅ اتصال به تلگرام موفق - ربات: " . $result['result']['first_name'] . "\n";
    } else {
        echo "❌ خطا در اتصال به تلگرام\n";
    }
    
    // تست اتصال به NewsAPI
    $apiKey = Config::get('apis.news_api.key');
    $response = $client->get("https://newsapi.org/v2/sources?apiKey={$apiKey}");
    $result = json_decode($response->getBody(), true);
    
    if ($result['status'] === 'ok') {
        echo "✅ اتصال به NewsAPI موفق\n";
    } else {
        echo "❌ خطا در اتصال به NewsAPI\n";
    }
    
    echo "\n🎉 راه‌اندازی با موفقیت انجام شد!\n";
    echo "\nبرای شروع ربات:\n";
    echo "php index.php\n";
    echo "\nبرای تست:\n";
    echo "php index.php --test\n";
    
} catch (Exception $e) {
    echo "❌ خطا در راه‌اندازی: " . $e->getMessage() . "\n";
    exit(1);
}
