<?php

/**
 * اسکریپت ارسال پیام تست به ربات
 * Send Test Message to Bot
 */

// بارگذاری autoloader
require_once __DIR__ . '/../vendor/autoload.php';
require_once __DIR__ . '/../src/Config.php';
require_once __DIR__ . '/../src/DatabaseManager.php';
require_once __DIR__ . '/../src/Services/TranslationService.php';
require_once __DIR__ . '/../src/Services/NewsFetcher.php';
require_once __DIR__ . '/../src/Services/TelegramBot.php';

echo "📤 ارسال پیام تست به ربات...\n";

try {
    // اتصال به پایگاه داده
    $dbPath = Config::get('database.path', __DIR__ . '/../storage/database.sqlite');
    $db = new DatabaseManager($dbPath);
    
    // ایجاد ربات
    $botToken = Config::get('bot.token');
    $channelId = Config::get('bot.channel_id');
    
    $bot = new TelegramBot($botToken, $channelId, $db);
    
    // ارسال پیام تست
    $adminUserId = 315447992;
    $testMessage = "🧪 تست دستورات ربات\n\n";
    $testMessage .= "لطفاً دستور /start را ارسال کنید تا ببینم آیا ربات پاسخ می‌دهد.\n\n";
    $testMessage .= "🕐 زمان: " . date('Y/m/d H:i:s');
    
    $success = $bot->sendPrivateMessage($adminUserId, $testMessage);
    
    if ($success) {
        echo "✅ پیام تست ارسال شد\n";
        echo "📱 حالا دستور /start را به ربات ارسال کنید\n";
    } else {
        echo "❌ خطا در ارسال پیام تست\n";
    }
    
} catch (Exception $e) {
    echo "❌ خطا: " . $e->getMessage() . "\n";
}
